package furny.ga.logger.entities;

import java.util.Date;

import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

/**
 * Database entry for an log event.
 * 
 * @since 11.08.2012
 * @author Stephan Dreyer
 */
@Entity
@Cache(usage = CacheConcurrencyStrategy.READ_ONLY)
public class LogEvent {

  /** The id. */
  private long id;

  /** The date. */
  private Date date;

  /** The type. */
  private EventType type;

  /** The evaluation run. */
  private EvaluationRunEntry evaluationRun;

  /**
   * Instantiates a new log event.
   */
  private LogEvent() {

  }

  /**
   * Instantiates a new log event.
   * 
   * @param date
   *          the date
   * @param run
   *          the run
   * @param type
   *          the type
   */
  public LogEvent(final Date date, final EvaluationRunEntry run,
      final EventType type) {
    this.date = date;
    this.evaluationRun = run;
    this.type = type;
  }

  /**
   * Gets the id.
   * 
   * @return the id
   */
  @Id
  @GeneratedValue
  public long getId() {
    return id;
  }

  /**
   * Sets the id.
   * 
   * @param id
   *          the new id
   */
  private void setId(final long id) {
    this.id = id;
  }

  /**
   * Gets the evaluation run.
   * 
   * @return the evaluation run
   */
  @ManyToOne
  public EvaluationRunEntry getEvaluationRun() {
    return evaluationRun;
  }

  /**
   * Sets the evaluation run.
   * 
   * @param evaluationRun
   *          the new evaluation run
   */
  public void setEvaluationRun(final EvaluationRunEntry evaluationRun) {
    this.evaluationRun = evaluationRun;
  }

  /**
   * Gets the date.
   * 
   * @return the date
   */
  public Date getDate() {
    return date;
  }

  /**
   * Sets the date.
   * 
   * @param date
   *          the new date
   */
  public void setDate(final Date date) {
    this.date = date;
  }

  /**
   * Gets the type.
   * 
   * @return the type
   */
  @Enumerated(EnumType.STRING)
  public EventType getType() {
    return type;
  }

  /**
   * Sets the type.
   * 
   * @param type
   *          the new type
   */
  public void setType(final EventType type) {
    this.type = type;
  }
}
